use master
GO

set nocount on 

--set to 0 to skip updating the A4Survey_Client_Template database, or to 1 to update the template database
declare @ProcessTemplateDB bit = 1  

declare @ClientPayload01 nvarchar(max) = N'
-- 66436
EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''SearchBarForAllColumns'', ''Boolean''
EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''HideTableByDefault'', ''Boolean''
EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''DisplayAllSelectedAndUnselectedTabs'', ''Boolean''
-- 66464
EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''HideTableHeader'', ''Boolean''
EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''HideTablePageNavigation'', ''Boolean''
'


declare @ClientPayload02 nvarchar(max) = N'
-- 66439
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].A4S_sp_GetLookupTableName'') AND type in (N''P'', N''  PC''))
DROP PROCEDURE [A4S_sp_GetLookupTableName]
'

declare @ClientPayload03 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_GetLookupTableName]
    @tableName NVARCHAR(max),
    @search NVARCHAR(max) = '''',
    @advanceFilter NVARCHAR(max) = '''',
    @searchColumns NVARCHAR(max) = '''',
    @sort NVARCHAR(255) = '''',
    @startIndex INT = 1,
    @endIndex INT = 10
AS
BEGIN
    SET NOCOUNT ON;

    DECLARE @innerQuery NVARCHAR(max);
    DECLARE @stmt NVARCHAR(max);

    SET @innerQuery = ''(SELECT * FROM dbo.['' + @tableName + '']) AS subquery'';

    DECLARE @filterQuery NVARCHAR(max) = '''';
    DECLARE @searchQuery NVARCHAR(max) = '''';

    IF @searchColumns <> '''' AND  @search <> ''''
        SET @searchQuery = '' ('' + REPLACE(@searchColumns, ''{0}'', @search) + '') '' 
    ELSE
        SET @searchQuery = '''' 

    IF @searchQuery <> '''' OR @advanceFilter <> ''''
    BEGIN
        SET @filterQuery = '' WHERE'';

        -- Add search
        IF @search <> ''''
        BEGIN
            SET @filterQuery = @filterQuery + @searchQuery;
        END

        -- Add advance filter
        IF @advanceFilter <> ''''
        BEGIN
            IF @filterQuery <> '' WHERE''
                SET @filterQuery = @filterQuery + '' AND '';
            
            SET @filterQuery = @filterQuery + @advanceFilter;
        END
    END

    SET @stmt = ''SELECT * FROM '' +
                ''(SELECT ROW_NUMBER() OVER (ORDER BY '' + @sort + '') AS [RowNum], * '' +
                ''FROM '' + @innerQuery + @filterQuery + '') rowquery '' +
                ''WHERE [RowNum] >= @startIndex AND [RowNum] <=  @endIndex '' +
                ''ORDER BY [RowNum]'';
    
    EXEC sp_executesql @stmt, N''@startIndex INT, @endIndex INT'', @startIndex, @endIndex    

    SET @stmt = ''SELECT COUNT(*) AS [TotalRecords] FROM '' + @innerQuery;
    EXEC sp_executesql @stmt;

    IF @filterQuery <> ''''
    BEGIN
        SET @stmt = ''SELECT COUNT(*) AS [TotalDisplayedRecords] FROM '' + @innerQuery + @filterQuery;
        EXEC sp_executesql @stmt;
    END;
END;
'

declare @ClientPayload04 nvarchar(max) = N'
-- 66447
-- Delete the existing key settings
DELETE FROM [SAT].[QuestionTypeSettingDefinitions] Where QuestionTypeId=28 and QuestionSettingDefinitionId in (SELECT Id FROM [SAT].[QuestionSettingDefinitions] WHERE NAME IN (''Unselected'',''Selected'',''All'', ''AddChoiceButtonLabel''))
DELETE FROM [SAT].[LocalizableTexts_TranslatableQuestionSetting]  Where QuestionSettingDefinitionId in (SELECT Id FROM [SAT].[QuestionSettingDefinitions] WHERE NAME IN (''Unselected'',''Selected'',''All'', ''AddChoiceButtonLabel''))
DELETE FROM [SAT].[QuestionSettingDefinitions] WHERE Name in (''Unselected'',''Selected'',''All'', ''AddChoiceButtonLabel'') 


EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''AllowRespondentToAddCustomChoice'', ''Boolean''

-- 0 Not Allowed, 1 Private, 2 Public - enum LookupTableInputAccessEnum
EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''AnonymousRespondentInput'', ''Numeric'', 0, 0
EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''LoggedInRespondentInput'', ''Numeric'', 1, 0
EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''PhoneAgentInput'', ''Numeric'', 2, 0


IF EXISTS(SELECT 1 FROM [SAT].[QuestionTypes] WHERE Id = 28)
BEGIN
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''LookupTableAll'', ''Text'', ''All'', 1
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''LookupTableSelected'', ''Text'', ''Selected'', 1
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''LookupTableUnselected'', ''Text'', ''Unselected'', 1
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''LookupTableAddChoiceButtonLabel'', ''Text'', ''Add Choice'', 1
END
'

declare @ClientPayload05 nvarchar(max) = N'
-- 66452
UPDATE [SAT].[Themes]
SET SettingsJson = JSON_MODIFY(SettingsJson, ''$.QuestionSpacing'', JSON_QUERY(''{"PageHeader":8,"PageFooter":8,"BetweenComponents":16,"WithinComponents":8}''))
WHERE ThemeCategoryId = 1
'

declare @ClientPayload06 nvarchar(max) = N'
-- 66468
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].A4S_sp_GetLookupTableRows'') AND type in (N''P'', N'' PC''))
DROP PROCEDURE [A4S_sp_GetLookupTableRows]
'

declare @ClientPayload07 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_GetLookupTableRows]
 @tableId int,
 @filter NVARCHAR(max) = '''',
 @search NVARCHAR(max) = '''',
 @searchColumns NVARCHAR(max) = '''',
 @advanceFilter NVARCHAR(max) = '''',
 @sort NVARCHAR(255),
 @startIndex INT = 1,
 @endIndex INT = 10,
 @selected nvarchar(max) = '''',
 @excludeSelected bit = 0,
 @respondentId int = 0
AS
BEGIN
 SET NOCOUNT ON
 
 DECLARE @databaseName NVARCHAR(64) = DB_NAME()
 DECLARE @clientId INT = dbo.GetClientId(@databaseName)
 DECLARE @innerQuery nvarchar(max) 
 DECLARE @stmt nvarchar(max) 
 DECLARE @tableName NVARCHAR(255) 


 SET @stmt = ''SELECT @tableNameOUT = Name FROM dbo.LookupTables WHERE Id = '' + CONVERT(nvarchar, @tableId)
 EXEC sp_executesql @stmt, N''@tableNameOUT nvarchar(255) OUTPUT'',  @tableNameOUT=@tableName OUTPUT 


 SET @innerQuery = ''(SELECT * FROM dbo.[LookupTable_'' + @tableName + '']) AS subquery''

 IF @respondentId <> 0 
 BEGIN
   SET @innerQuery = ''(SELECT * FROM dbo.[LookupTable_'' + @tableName + ''] WHERE 
   (InternalPrivate = ''''false'''' OR InternalRespondent = '' + CONVERT(nvarchar, @respondentId) + '') AND InternalVisible = ''''true'''') AS subquery''
 END

 DECLARE @filterQuery NVARCHAR(max) = ''''
 DECLARE @searchQuery NVARCHAR(max) = ''''

 IF @searchColumns <> '''' AND  @search <> ''''
  SET @searchQuery = '' ('' + REPLACE(@searchColumns, ''{0}'', @search) + '') '' 
 ELSE
  SET @searchQuery = '''' 


  IF @filter <> '''' OR @searchQuery <> '''' OR @selected <> '''' OR @advanceFilter <> ''''
  BEGIN
  SET @filterQuery = '' WHERE''

     -- Add selected rows
        IF @selected <> ''''
   SET @filterQuery = @filterQuery + '' InternalId '' + (CASE WHEN @excludeSelected = 1 THEN ''NOT'' ELSE '''' END) + '' IN ('' + @selected + '') ''
   
  -- Add filter
  IF @filter <> ''''
  BEGIN 
   IF @selected <> ''''
    SET @filterQuery = @filterQuery + '' AND '' 

   SET @filterQuery = @filterQuery + '' '' + @filter
  END

  -- Add search
  IF @search <> ''''
  BEGIN
   IF @filter <> '''' OR @selected <> ''''
    SET @filterQuery = @filterQuery + '' AND '' 
  
   SET @filterQuery = @filterQuery + @searchQuery
  END

  -- Add advance filter
  IF @advanceFilter <> ''''
  BEGIN
   IF @filterQuery <> '' WHERE''
    SET @filterQuery = @filterQuery + '' AND '' 
  
   SET @filterQuery = @filterQuery + @advanceFilter
  END
  END

 -- '' WHERE '' + CAST(@showInactive AS VARCHAR(8)) + '' = 1 OR subquery.Status = 3 AND subquery.Name LIKE ''''%'' + @search + ''%''''
 
 SET @stmt = ''SELECT * FROM
 (SELECT ROW_NUMBER() OVER (ORDER BY '' + @sort + '') AS [RowNum], * 
 FROM '' + @innerQuery + @filterQuery +'') rowquery
 WHERE [RowNum] >= '' + CONVERT(nvarchar, @startIndex) + '' AND [RowNum] <= '' + CONVERT(nvarchar, @endIndex) + ''
 ORDER BY [RowNum]''
 
 EXEC sp_executesql @stmt
   
 SET @stmt = ''SELECT COUNT(*) AS [TotalRecords] FROM '' + @innerQuery
 EXEC sp_executesql @stmt
 
 IF @filterQuery <> ''''
 BEGIN
  SET @stmt = ''SELECT COUNT(*) AS [TotalDisplayedRecords] FROM '' + @innerQuery + @filterQuery
  EXEC sp_executesql @stmt
 END 
END
'

declare @ClientPayload08 nvarchar(max) = N'
-- 66473
EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''Version'', ''Text''
'

declare @ClientPayload09 nvarchar(max) = N'
-- 66476
IF EXISTS(SELECT 1 FROM [SAT].[QuestionTypes] WHERE Id = 28)
BEGIN
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''AddChoicePopupTitle'', ''Text'', ''Add a choice'', 1
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''ConfirmationButtonLabel'', ''Text'', ''Confirm'', 1
    EXEC [SAT].VX_sp_CreateQuestionTypeSetting ''LookupTable'', ''CancelButtonLabel'', ''Text'', ''Cancel'', 1
END
'

declare @ClientPayload10 nvarchar(max) = N'
-- 66481
----------------------------------
-- A4S_sp_GetLookupTableResponsesForMerge
----------------------------------
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[A4S_sp_GetLookupTableResponsesForMerge]'') AND type in (N''P'', N''PC''))
    DROP PROCEDURE [dbo].[A4S_sp_GetLookupTableResponsesForMerge]
'

declare @ClientPayload11 nvarchar(max) = N'
CREATE PROCEDURE [dbo].[A4S_sp_GetLookupTableResponsesForMerge]
    @lookupTableId INT = 0
AS
BEGIN
    DECLARE @lookupTableQuestionSettingDefinitionId INT;
    SELECT @lookupTableQuestionSettingDefinitionId = [Id]
    FROM [SAT].[QuestionSettingDefinitions]
    WHERE [Name] = ''LookupTable'';
 
    DECLARE @columnNameVariableSettingDefinitionId INT; 
    SELECT @columnNameVariableSettingDefinitionId = [Id]
    FROM [SAT].[VariableSettingDefinitions]
    WHERE [Name] = ''ColumnName'';
 
    SELECT v.[Id] AS [VariableId], v.[Name] AS [VariableName], vs.[Value] AS [ColumnName], b.[QuestionnaireId] as [SurveyId], biq.[Id] as QuestionId
    FROM [SAT].[QuestionSettings] qs
    INNER JOIN [SAT].[BlockItems_Question] biq
        ON qs.[QuestionId] = biq.[Id]
        AND qs.[Version] = biq.[Version]
    INNER JOIN [SAT].[BlockItems] bi
        ON biq.[Id] = bi.[Id]
        AND biq.[Version] = bi.[Version]
    INNER JOIN [SAT].[Blocks] b
        ON bi.[BlockId] = b.[Id]
        AND bi.[Version] = b.[Version]
    INNER JOIN [SAT].[Variables] v
        ON qs.[QuestionId] = v.[QuestionId]
        AND qs.[Version] = v.[Version]
    INNER JOIN [SAT].[VariableSettings] vs
        ON v.[Id] = vs.[VariableId]
        AND v.[Version] = vs.[Version]
        AND vs.[VariableSettingDefinitionId] = @columnNameVariableSettingDefinitionId
    WHERE qs.[QuestionSettingDefinitionId] = @lookupTableQuestionSettingDefinitionId
        AND qs.[Version] = 0
        AND qs.[Value] = @lookupTableId
END
'

declare @ClientPayload12 nvarchar(max) = N'
-- 66483
DECLARE @TableName NVARCHAR(MAX);
DECLARE @TableFullName NVARCHAR(MAX);
DECLARE @SQL NVARCHAR(MAX);

DECLARE table_cursor CURSOR FOR
SELECT [Name]
FROM [dbo].[LookupTables];

OPEN table_cursor;

FETCH NEXT FROM table_cursor INTO @TableName;

WHILE @@FETCH_STATUS = 0
BEGIN
    SET @TableFullName = ''LookupTable_'' + @TableName;

    IF EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ''dbo'' AND TABLE_NAME = @TableFullName)
BEGIN
        -- Initialize the SQL variable
        SET @SQL = ''ALTER TABLE '' + QUOTENAME(@TableFullName) + '' ADD '';

        -- Append column additions if they do not exist
        IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''dbo'' AND TABLE_NAME = @TableFullName AND COLUMN_NAME = ''InternalId'')
BEGIN
            SET @SQL = @SQL + ''[InternalId] [int] NULL,'';
END

        IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''dbo'' AND TABLE_NAME = @TableFullName AND COLUMN_NAME = ''InternalPrivate'')
BEGIN
            SET @SQL = @SQL + ''[InternalPrivate] [bit] NOT NULL DEFAULT 0,'';
END

        IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''dbo'' AND TABLE_NAME = @TableFullName AND COLUMN_NAME = ''InternalRespondent'')
BEGIN
            SET @SQL = @SQL + ''[InternalRespondent] [nvarchar](max) NULL,'';
END

        IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''dbo'' AND TABLE_NAME = @TableFullName AND COLUMN_NAME = ''InternalSource'')
BEGIN
            SET @SQL = @SQL + ''[InternalSource] [nvarchar](max) NULL,'';
END

        IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''dbo'' AND TABLE_NAME = @TableFullName AND COLUMN_NAME = ''InternalSurveyId'')
BEGIN
            SET @SQL = @SQL + ''[InternalSurveyId] [int] NULL,'';
END

        IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''dbo'' AND TABLE_NAME = @TableFullName AND COLUMN_NAME = ''InternalSurveyName'')
BEGIN
            SET @SQL = @SQL + ''[InternalSurveyName] [nvarchar](max) NULL,'';
END

        IF NOT EXISTS (SELECT 1 FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_SCHEMA = ''dbo'' AND TABLE_NAME = @TableFullName AND COLUMN_NAME = ''InternalVisible'')
BEGIN
            SET @SQL = @SQL + ''[InternalVisible] [bit] NOT NULL DEFAULT 1,'';
END

        -- Remove trailing comma and add semicolon
        IF RIGHT(@SQL, 1) = '',''
BEGIN
            SET @SQL = LEFT(@SQL, LEN(@SQL) - 1) + '';'';
EXEC sp_executesql @SQL;
END
END

FETCH NEXT FROM table_cursor INTO @TableName;
END

-- Close and deallocate the cursor
CLOSE table_cursor;
DEALLOCATE table_cursor;
'

--declare @SurveyPayload01 nvarchar(max) = N'waitfor delay ''0:00:01'''

create table #DB (
	DBName nvarchar(128),
	Processed tinyint default 0
)
create table #Survey (
	DBName nvarchar(128),
	SchemaName nvarchar(128),
	Processed tinyint default 0
)
create table #SurveyVerif (
	DBName nvarchar(128),
	SchemaName nvarchar(128)
)
create table #SurveysDone (
	DBName nvarchar(128) collate database_default,
	SchemaName nvarchar(128) collate database_default
)
declare @AllDone bit = 0, 
        @TotalClients int, 
		@TotalSurveys int, 
		@ClientCounter int, 
		@SurveyCounter int, 
		@ThisClient nvarchar(128), 
		@ThisSurvey nvarchar(128), 
		@ClientCursor cursor, 
		@SurveyCursor cursor, 
		@DBSQL nvarchar(200), 
		@SQL nvarchar(max), 
		@StatusMessage varchar(max), 
		@StatusPercent tinyint

while @AllDone = 0 begin
	select @TotalClients = 0, @TotalSurveys = 0, @ClientCounter = 0, @SurveyCounter = 0
	insert into #DB 
	select 'A4Survey_Client_' + cast(Id as nvarchar(16)), 0 from Acuity4.dbo.Client
	     
    if @ProcessTemplateDB = 1 
	   insert into #DB values (N'A4Survey_Client_Template', 0)

	select @TotalClients = count(*) 
	       from #DB
	
	set @ClientCursor = cursor scroll dynamic for select DBName from #DB for update of Processed
	open @ClientCursor
	fetch next from @ClientCursor into @ThisClient
	while @@FETCH_STATUS = 0 begin
		select @ClientCounter += 1
		select @DBSQL = @ThisClient + N'.sys.sp_executesql'
		select @SQL = N'insert into #Survey select ''' + @ThisClient + ''', SchemaName, 0 from ' + @ThisClient + '.dbo.Survey except select DBName, SchemaName, 0 from #SurveysDone'
		exec @DBSQL @SQL
		select @StatusMessage = 'Updating client database "%s" (%u of %u, %u%%)', @StatusPercent = 100.0 * @ClientCounter / @TotalClients
		raiserror (@StatusMessage, 0, 1, @ThisClient, @ClientCounter, @TotalClients, @StatusPercent) with nowait
		
		print 'Client Payload 1'
		select @SQL = replace(replace(@ClientPayload01, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 2'
		select @SQL = replace(replace(@ClientPayload02, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 3'
		select @SQL = replace(replace(@ClientPayload03, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 4'
		select @SQL = replace(replace(@ClientPayload04, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 5'
		select @SQL = replace(replace(@ClientPayload05, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 6'
		select @SQL = replace(replace(@ClientPayload06, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 7'
		select @SQL = replace(replace(@ClientPayload07, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 8'
		select @SQL = replace(replace(@ClientPayload08, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 9'
		select @SQL = replace(replace(@ClientPayload09, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 10'
		select @SQL = replace(replace(@ClientPayload10, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 11'
		select @SQL = replace(replace(@ClientPayload11, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'Client Payload 12'
		select @SQL = replace(replace(@ClientPayload12, '#CLIENT ID#', substring(@ThisClient, 17, 8)), '#CLIENT DB#', @ThisClient)
		if isnull(@SQL, '') <> '' exec @DBSQL @SQL

		print 'All Client Payload done for  client ' + @ThisClient + '!'

		update #DB set Processed = 1 where current of @ClientCursor
		fetch next from @ClientCursor into @ThisClient
	end


	close @ClientCursor
	deallocate @ClientCursor

-- Backup client template db if it was updated
	IF @ProcessTemplateDB = 1 
    BEGIN
      PRINT 'Creating backup for A4Survey_Client_Template';
      SET @SQL = 'USE Acuity4;
                  exec [dbo].[VX_sp_BackupClientTemplateDatabase]'
      EXEC (@SQL); 
    END

    SELECT @AllDone = 1
end



--select * from #DB
--select * from #Survey

drop table #DB
drop table #Survey
drop table #SurveyVerif
drop table #SurveysDone